﻿Option Strict On
Imports System.Xml.Linq
Imports System.Windows.Media.Imaging
Partial Public Class MainPage
    Inherits UserControl

    Public Sub New()
        InitializeComponent()
    End Sub
    Dim xmldoc As XElement
    Private Sub MainPage_Loaded(ByVal sender As Object, ByVal e As System.Windows.RoutedEventArgs) Handles Me.Loaded
        Dim myImageList As New List(Of String)
        xmldoc = XElement.Load("photo_etc.xml")

        For Each result In From c In xmldoc.Descendants("情報") Select c
            Dim fileNameLen As Integer = Len(result.Element("画像名").Value) - 4
            Dim imageFileName As String = Left(result.Element("画像名").Value, fileNameLen)
            myImageList.Add(imageFileName)
        Next
        ListBox1.ItemsSource = myImageList
    End Sub

    Private Sub ListBox1_SelectionChanged(ByVal sender As Object, ByVal e As System.Windows.Controls.SelectionChangedEventArgs) Handles ListBox1.SelectionChanged
        StackPanel1.Children.Clear()
        Dim myStackPanel As New StackPanel
        myStackPanel.Orientation = Orientation.Vertical
        Dim imageName As String = xmldoc.Descendants("情報")(ListBox1.SelectedIndex).<画像名>.Value
        Dim imageComment As String = xmldoc.Descendants("情報")(ListBox1.SelectedIndex).<説明>.Value
        Dim myImage As New Image
        With myImage
            .Width = 320
            .Height = 240
            .Source = New BitmapImage(New Uri("Image/" & imageName, UriKind.Relative))
            .Margin = New Thickness(10)
        End With

        Dim myTextBlock As New TextBlock
        With myTextBlock
            .FontSize = 14
            .Text = imageComment
            .HorizontalAlignment = Windows.HorizontalAlignment.Center
        End With
      
        With myStackPanel.Children
            .Add(myImage)
            .Add(myTextBlock)
        End With

        StackPanel1.Children.Add(myStackPanel)
    End Sub
End Class